/****** Object:  View [dbo].[V_ITEC_SUITE_EST_PROD_SUPRIMENTO_ENTREGA_LOJA_PRODUTO_DEMANDA]    Script Date: 01/22/2013 09:45:54 ******/
IF EXISTS (SELECT * FROM sys.views
					 WHERE
						object_id = OBJECT_ID(N'[dbo].[V_ITEC_SUITE_EST_PROD_SUPRIMENTO_ENTREGA_LOJA_PRODUTO_DEMANDA]'))
	DROP VIEW [dbo].[V_ITEC_SUITE_EST_PROD_SUPRIMENTO_ENTREGA_LOJA_PRODUTO_DEMANDA]

GO 
--select * from  V_ITEC_SUITE_EST_PROD_SUPRIMENTO_ENTREGA_LOJA_PRODUTO_DEMANDA where cd_emp =1 and cd_usu = 1
CREATE VIEW V_ITEC_SUITE_EST_PROD_SUPRIMENTO_ENTREGA_LOJA_PRODUTO_DEMANDA AS
SELECT 
	E.CD_EMP,
	E.CD_USU,
	E.CD_PROD,
	P.DS_PROD,
	F.NM_FABRIC,
	l.DS_ARV_MERC_LINHA,
	Min(S.DS_SIGLA) DS_SIGLA,
	( CONVERT(MONEY, Replace(P.APRES_EMB_CP, ',', '.')) * CONVERT(MONEY, Replace(P.APRES_QT_CP, ',', '.')) ) APRES_QT_CP,
	Isnull(P.QT_EMB_FECHADA_CP, 1)                                                                           AS QT_EMB_FECHADA_CP,
	Isnull(P.QT_EMB_ALTERNATIVA_CP, 1)                                                                       AS QT_EMB_ALTERNATIVA_CP,
	Sum(E.QT_EST)                                                                                            AS QT_EST,
	Sum(E.QTDE_PROD)                                                                                         AS QTDE_PROD,
	Sum(E.QTDE_SUGESTAO)                                                                                     AS QTDE_PULMAO,
	CASE WHEN SUM(E.QTDE_PROD)=0 THEN
		0
	ELSE
		SUM(E.VLR_PROD*E.QTDE_PROD)/SUM(E.QTDE_PROD) 
	END AS VLR_PROD,
	CASE
	WHEN Isnull(E.PERC_DESC, 0) > 0 THEN Isnull(E.PERC_DESC, 0)
	ELSE Isnull(P.PERC_DESC_FABRICA, 0)
	END                                                                                                      PERC_DESC
FROM   
	EST_PROD_SUPRIMENTO_ENTREGA_LOJA E
	INNER JOIN EST_PROD P
			ON E.CD_EMP = P.CD_EMP
				AND E.CD_PROD = P.CD_PROD
	INNER JOIN EST_PROD_FABRIC F
			ON P.CD_FABRIC = F.CD_FABRIC
	INNER JOIN EST_PROD_CURVA_SIGLA S
			ON E.CD_SIGLA = S.CD_SIGLA
    INNER JOIN  EST_PROD_EST_ARV_MERCADOLOGICA A
        ON P.CD_EMP = A.CD_EMP
        AND P.CD_PROD = A.CD_PROD
    INNER JOIN  EST_ARV_MERC_LINHA l
        ON a.CD_EMP = l.CD_EMP
        AND a.CD_ARV_MERC_LINHA = l.CD_ARV_MERC_LINHA
GROUP  BY 
 E.CD_EMP,
 E.CD_USU,
 E.CD_PROD,
 P.DS_PROD,
 F.NM_FABRIC,
 l.DS_ARV_MERC_LINHA,
 APRES_EMB_CP,
 P.APRES_QT_CP,
 P.QT_EMB_FECHADA_CP,
 P.QT_EMB_ALTERNATIVA_CP,
 E.PERC_DESC,
 P.PERC_DESC_FABRICA